#include "Ennemis.h"
#include "CApplication.h"

#define scal 16.0

#include <math.h>
#define PI 3.1415926535897932384626433832795

#define P_APPROCHE 0
#define P_ATTACK 1
#define P_FUITE 2

//====================================== CItEnnemi =======================================
Vecteur *CItEnnemi::ciblePos=NULL;
Vecteur *CItEnnemi::cibleVel=NULL;

//mettre une cible
void CItEnnemi::setCiblePosVel(Vecteur *ciblePosT,Vecteur *cibleVelT)
{
    CItEnnemi::ciblePos=ciblePosT;
    CItEnnemi::cibleVel=cibleVelT;
}
//----------------------------------------------------------------------------------------






//====================================== CEnnemiMov =======================================
CEnnemiMov::CEnnemiMov(float shield,unsigned char dmgS,unsigned short tmShot,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CCollideMv(px,py,pz,fx,fy,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)
{
    PRESSISION=0.01;
    this->shield=shield;
    this->dmgS=dmgS;
    this->tmShot=tmShot;
}

CEnnemiMov::~CEnnemiMov()
{
}

//Calcul du temps qu'il y a avant impact sur la trajectorie de la cible
float CEnnemiMov::calculCibleImpact(float projSpeed,float rbase)
{
    if(!(ciblePos && cibleVel))return 0.0;
    Vecteur p(*ciblePos),v(*cibleVel);
    
    p-=pos;
    v-=vel;
    v*=(1.0+2.0*(((rand()/RAND_MAX)-0.5)*PRESSISION));
    srand((time_t) rand());
    
    float a,b,delta;
    
    a=(v*v-projSpeed*projSpeed);
    
    if(a==0.0)return 0.0;
    
    b=(p*v-projSpeed*rbase);
    
    delta=b*b-a*(p*p-rbase*rbase);
    
    if(delta<0.0)return 0.0;
    
    if(delta==0)return -b/a;
    
    
    
    return -(b+sqrtf(delta))/a;
}
//----------------------------------------------------------------------------------------





//====================================== CEnnemiFix =======================================
CEnnemiFix::CEnnemiFix(float shield,unsigned char dmgS,unsigned short tmShot,float px,float py,float pz,float rayon,float coefElastic)
:CCollide(px,py,pz,rayon,coefElastic)
{
    PRESSISION=0.01;
    this->shield=shield;
    this->dmgS=dmgS;
    this->tmShot=tmShot;
}

CEnnemiFix::~CEnnemiFix()
{
}

//Calcul du temps qu'il y a avant impact sur la trajectorie de la cible
float CEnnemiFix::calculCibleImpact(float projSpeed,float rbase,float h)
{
    if(!(ciblePos && cibleVel))return 0.0;
    Vecteur p(*ciblePos),v(*cibleVel),ps;
    
    p-=pos;
    p.y-=h;
    //v-=vel;
    v*=(1.0+(((rand()/RAND_MAX)-0.5)*PRESSISION));
    srand((time_t) rand());
    
    float a,b,delta;
    
    a=(v*v-projSpeed*projSpeed);
    
    if(a==0.0)return 0.0;
    
    b=(p*v-projSpeed*rbase);
    
    delta=b*b-a*(p*p-rbase*rbase);
    
    if(delta<0.0)return 0.0;
    
    if(delta==0)return -b/a;
    
    
    
    return -(b+sqrtf(delta))/a;
}
//----------------------------------------------------------------------------------------





//====================================== CEnnemiVolant =======================================
void CEnnemiVolant::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
    if(ampliImpact<0.0)ampliImpact=-ampliImpact;
    
    if(masse>0.0)masse*=ampliImpact;
    else masse=ampliImpact;
    
    shield-=dmg*masse;// *(ampliImpact>=0.0?ampliImpact:-ampliImpact);
    if(shield<=0.0)colid_flags=0;
    //cldDisable(IN_LIFE);
    
    if(masse>0.0)ampliImpact=(masse/(this->masse))*0.4;
    else ampliImpact=masse*0.3;
        
    float t,t2,t3;
    Vecteur tt;
    
    //pImpact-=pos;
    //pImpact.normalize();
    
    mod.getAxeY(tt);
    t=tt*forceImpact;
    
    mod.getAxeX(tt);
    t2=tt*forceImpact;
    frot.z+=t2*t*ampliImpact;
    
    mod.getAxeZ(tt);
    t3=tt*forceImpact;
    frot.x+=t3*t*ampliImpact;
    
    frot.y+=t3*t2*ampliImpact;
    
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
}

void CEnnemiVolant::applyExplosion(float dmg,float proxi)
{
    shield-=dmg*proxi;
    if(shield<=0.0)colid_flags=0;//cldDisable(IN_LIFE);
}

//fonction de tire
void CEnnemiVolant::Shoot()
{
    Vecteur vl,t,f;
    
    /*
    mod.getAxeZ(vl);
    vl*=1.3;
    //vl+vel;
    
    //if(bRL)t.x=(0.29/4.0)*scal;//0.521946;
    //else t.x=(-0.29/4.0)*scal;//0.521946;
    
    t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
    t.y=-rayon*0.15;//0.1;
    t.z=rayon+0.01;//0.521946;
    mod.multVect(t,t);
    
    if(bRL)bRL=false;else bRL=true;
    
    t+=pos;
    
    projectilT(t,vl);
    */
    
    mod.getAxeZ(vl);
    
    t.y=(0.0)*scal;//0.1;
    
    unsigned char idP=(idMProj & 0x1F);
    
    bool bLzr;
    
    if(idP<NBLASER)//laser ?
    {
        idP+=LASERBLEU;
        bLzr=true;
    }
    else
    {
        idP+=(MISSILE1-10);
        bLzr=false;
    }
    
    if(bLzr)
    {
        //Laser ?
        t.z=rayon+0.01;//0.521946;
        vl*=1.3;
    }
    else
    {
        //Missile ?
        t.z=rayon+5.0;//0.521946;
        f=vl;
        //f*=0.01;
        vl*=0.1;
    }
    
    switch(idMProj & 0xE0)
    {
    case (0<<5):
        timeShot=tmShot;
        
        t.x=(0.0/4.0)*scal;//0.521946;
        mod.multVect(t,t);
        
        t+=pos;
        
        if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);}
        else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.4);}
        break;
    case (1<<5):
        timeShot=tmShot;
        
        t.x=(-0.32/4.0)*scal;//0.521946;
        mod.multVect(t,t);
        
        t+=pos;
        
        if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));CApplication::selfPointer->o_son.playSound(DUALSHOT,pos.z);}
        else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.4);}
        {
            Vecteur tt;
            mod.getAxeX(tt);
            tt*=((0.32*2)/4.0)*scal;
            t+=tt;
            if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));}
            else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));}
        }
        break;
    case (2<<5):
        timeShot=tmShot;
        
        t.x=((bRL?0.35:-0.35)/4.0)*scal;//0.521946;
        mod.multVect(t,t);
        
        if(bRL)bRL=false;else bRL=true;
        
        t+=pos;
        
        if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);}
        else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.4);}
        break;
    case (3<<5):
        timeShot=tmShot;
        
        t.x=(-0.4/4.0)*scal;//0.521946;
        mod.multVect(t,t);
        
        t+=pos;
        
        if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));CApplication::selfPointer->o_son.playSound(TREESHOT,pos.z,0.5);}
        else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.4);}
        
        {
            Vecteur tt,tt2;
            mod.getAxeX(tt);
            mod.getAxeZ(tt2);
            tt*=((0.4)/4.0)*scal;
            tt2*=((2.0)/4.0)*scal;
            t+=tt;
            if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x+tt2.x,t.y+tt2.y,t.z+tt2.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));}
            else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x+tt2.x,t.y+tt2.y,t.z+tt2.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));}
            t+=tt;
            if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));}
            else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));}
        }
        break;
    case (4<<5):
        timeShot=tmShot;
        
        t.x=(((bRL==true)?-0.4:((bRL==0x55 || bRL==false)?0.0:0.4))/4.0)*scal;//0.521946;
        mod.multVect(t,t);
        
        if(bRL==true)bRL=0x55;
        else if(bRL==0x55)bRL=0xAA;
        else if(bRL==0xAA)bRL=false;
        else bRL=true;
        
        t+=pos;
        
        if(bLzr){CApplication::selfPointer->mCld.addLaser(new CProjectil(idP,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);}
        else {CApplication::selfPointer->mCld.addCollideSf(new CMissile(idP,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.4);}
        break;
    }
}

/*
void CEnnemiVolant::projectilT(Vecteur &t,Vecteur &vl)
{
    timeShot=tmShot;
    CApplication::selfPointer->mCld.addLaser(new CProjectil(idMProj,1000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,1.0,1.0,0.0,1.0));
}
*/

bool CEnnemiVolant::frameMove(float elapsedTime)
{
    if(pos.z<-10.0)return true;
    
    if(colid_flags==0)
    {
        CApplication::selfPointer->o_son.playSound(EXPLOENM+rand()%NBEXPLO,pos.z,0.8);
        if(rand()%2)CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon*0.67,rayon*1.33,8,16,17/1800.0,128.0/1024.0,128.0/1024.0,0));
        else CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon*0.67,rayon*1.33,8,16+17,17/1800.0,128.0/1024.0,128.0/1024.0,16));
        srand((time_t) rand());
        return true;
    }
    
    //float kLeft,kRight,kDown,kUp;
    //kLeft=kRight=kDown=kUp=0.0;
    
    float kLR,kUD;
    kLR=0.0;
    kUD=0.0;
    
    bool kSpace;
    kSpace=false;
    
    float flt;
    
    if(politique==P_APPROCHE || politique==P_ATTACK)
    {
        if(ciblePos)
        {
            //targ=*ciblePos;
            if((idMProj & 0x1F)<NBLASER)flt=calculCibleImpact(1.3,(rayon+0.5));//vel.length()
            else flt=calculCibleImpact(1.0,(rayon+5.0));//vel.length()
            
            if(politique==P_APPROCHE){if(pos.z<3000.0)politique=P_ATTACK;}
            else{if(pos.z<50.0)politique=P_FUITE;}
            
            if(flt>0.0)
            {
                targ=*cibleVel;
                targ*=flt;
                targ+=*ciblePos;
            }
            else
            {
             targ=*ciblePos;
             //if(politique==P_ATTACK)politique=P_APPROCHE;
            }
                   
            /*
            Vecteur trg;
            if(flt>0.0)
            {
                trg=*cibleVel;
                trg*=flt;
                trg+=*ciblePos;
            }
            else trg=*ciblePos;
            /*
            float tmpz=trg.z;
            trg*=TARG_MOV_SPEED;
            targ*=(1.0f-TARG_MOV_SPEED);
            targ+=trg;
            targ.z=tmpz;
            */
            //targ=trg;
            
        }
        else politique=P_FUITE;
    }
    else if(politique==P_FUITE)
    {
        targ.y=pos.y;
        targ.z=-100;
    }
    
    Vecteur t,T;
    mod.getAxeZ(t);
    //t.normalize();
    
    T=targ;
    T-=pos;
    T.normalize();
    
    bool accel=false;
    
    flt=T*t;
    
    //PRESSISION=0.00001;
    
    if(politique==P_ATTACK && flt>=0.99)kSpace=true;
    
    if(flt<(1.0-PRESSISION))
    {
        
        mod.getAxeX(t);
        
        /*
        flt=T*t;
        if(flt<-PRESSISION)kRight=true;
        else if(flt>PRESSISION)kLeft=true;
        
        mod.getAxeY(t);
        flt=T*t;
        if(flt<-PRESSISION)kUp=true;
        else if(flt>PRESSISION)kDown=true;
        */
        
        #define spdRt 0.0015
        #define spdLmnt 0.0001
        
        flt=T*t;
        if(flt<-PRESSISION)kLR=spdRt*flt;
        else if(flt>PRESSISION)kLR=spdRt*flt;
        
        if(kLR>spdLmnt)kLR=spdLmnt;
        else if(kLR<-spdLmnt)kLR=-spdLmnt;
        
        mod.getAxeY(t);
        flt=T*t;
        if(flt<-PRESSISION)kUD=spdRt*flt;
        else if(flt>PRESSISION)kUD=spdRt*flt;
        
        if(kUD>spdLmnt)kUD=spdLmnt;
        else if(kUD<-spdLmnt)kUD=-spdLmnt;
        
        //accel=kRight|kLeft|kUp|kDown;
    }
    
    //if(pos.x<-550.0){pos.x=-550.0;}
    //else if(pos.x>550.0){pos.x=550.0;}
    //if(pos.y<-550.0)pos.y=-550.0;
    //else if(pos.y>550.0)pos.y=550.0;
    
    forceFrotement(frot.x,0.994,elapsedTime);
    forceFrotement(frot.y,0.994,elapsedTime);
    forceFrotement(frot.z,0.994,elapsedTime);
    
    /*
    forceFrotement(rot.x,0.987,elapsedTime);
    rot.y-=PI;
    forceFrotement(rot.y,0.987,elapsedTime);
    rot.y+=PI;
    */
    forceFrotement(rot.z,0.995,elapsedTime);
    
    //if(pos.x<-500.0)frot.y+=0.0001*elapsedTime;
    //else if(pos.x>500.0)frot.y-=0.0001*elapsedTime;
    //if(pos.y<-500.0)frot.x+=0.0001*elapsedTime;
    //else if(pos.y>500.0)frot.x-=0.0001*elapsedTime;
    
    /*
    if(kLeft)frot.y+=0.00001*elapsedTime;
    if(kRight)frot.y-=0.00001*elapsedTime;
    if(kDown)frot.x+=0.0001*elapsedTime;
    if(kUp)frot.x-=0.0001*elapsedTime;
    */
    
    frot.y+=kLR*elapsedTime;
    frot.x+=kUD*elapsedTime;
    
    t=frot;
    t*=0.4*elapsedTime;
    //t.z=t.y*0.6;
    rot+=t;
    
    mod.setRotation(rot.x,rot.y,rot.z);
    
    if(timeShot>0.0)timeShot-=elapsedTime;
    if(kSpace)
    {
        if(timeShot<=0.0)Shoot();
    }
    
    mod.getAxeZ(force);
    
    //force*=(accel?0.0008:0.0004);
    force*=0.0004;
    
    mod.getAxeY(t);
    force.y+=t.y*0.000097;
    
    if(mt.predict(elapsedTime))
    {
        t.x=(0.0/4.0)*scal;//0.521946;
        t.y=-cfY;
        t.z=-cfZ;
        mod.multVect(mt.pos,t);
        mt.pos+=pos;
        //mt.vel=vel;
        //mt.vel*=0.5;
    }
    
    mt.frameMove(elapsedTime);
    
    return false;
}

void CEnnemiVolant::render()
{
    mod.draw(pos.x,pos.y,pos.z);
}

CEnnemiVolant::CEnnemiVolant(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM,float PRESSISION,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CEnnemiMov(shield,dmgS,tmShot,px,py,pz,fx,fy,fz,vx,vy,vz,masse,rayon,coefElastic,ffrot)//,targ(px+0.0f,py+0.0f,pz+100.0f)
{
    rot.x=0.0;
    rot.y=PI;
    rot.z=0.0;
    mod.loadObj(CApplication::selfPointer->protoBob.getPrototype(idM));
    bRL=false;
    timeShot=0.0;
    
    switch(idM)
    {
        case SHIP2:cfZ=0.3*SCL_SHIP2;cfY=0.0*SCL_SHIP2;break;
        case SHIP3:cfZ=0.3*SCL_SHIP3;cfY=0.0*SCL_SHIP3;break;
        case SHIP4:cfZ=0.3*SCL_SHIP4;cfY=0.0*SCL_SHIP4;break;
        case SHIP5:cfZ=0.3*SCL_SHIP5;cfY=0.0*SCL_SHIP5;break;
        
        case SHIP6:cfZ=0.17*SCL_SHIP6;cfY=0.0*SCL_SHIP6;break;
        case SHIP7:cfZ=0.33*SCL_SHIP7;cfY=0.0863*SCL_SHIP7;break;
        case SHIP8:cfZ=0.49*SCL_SHIP8;cfY=0.0863*SCL_SHIP8;break;
        case SHIP9:cfZ=0.49*SCL_SHIP9;cfY=0.0863*SCL_SHIP9;break;
        default:cfZ=rayon;cfY=0.0;//break;
    }
    
    //cfZ*=rayon;
    //cfY*=rayon;
    
    this->PRESSISION=PRESSISION;
    
    mt.setIdP(2);
    mt.setReTm(10.0);
    mt.setLife(300);
    mt.start();
    
    politique=P_APPROCHE;
    this->idMProj=idMProj;
    
    dmg=1;
}

CEnnemiVolant::~CEnnemiVolant()
{
}
//----------------------------------------------------------------------------------------













//====================================== CEnnemiFixSol =======================================
void CEnnemiFixSol::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
    if(ampliImpact<0.0)ampliImpact=-ampliImpact;
    
    if(masse>0.0)masse*=ampliImpact;
    else masse=ampliImpact;
    
    shield-=dmg*masse;// *(ampliImpact>=0.0?ampliImpact:-ampliImpact);
    if(shield<=0.0)colid_flags=0;
    
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,0.0,0.0,0.0,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,0.0,0.0,0.0,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,0.0,0.0,0.0,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,0.0,0.0,0.0,200,1.5,0.02);
}

void CEnnemiFixSol::applyExplosion(float dmg,float proxi)
{
    shield-=dmg*proxi;
    if(shield<=0.0)colid_flags=0;//cldDisable(IN_LIFE);
}

//calcul pour tirer en anticipant la trajectoir de la cible
//cela vite de refaire tout le frameMove, le frameMove appel cette fonction
//car il y a 2 type d'unit au sol (laser et missile ne vont pas  la mme vitesse)
float CEnnemiFixSol::getImct()
{
    return calculCibleImpact(0.99999,(rayon+4.0),mod3.getPosY()+rayon*0.5);//vel.length()
}

//Explosion de l'unit au sol
void CEnnemiFixSol::boom()
{
    CApplication::selfPointer->o_son.playSound(EXPLOENM+rand()%NBEXPLO,pos.z,0.4);
    if(rand()%2)CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon,rayon*2.0,8,16,17/1800.0,128.0/1024.0,128.0/1024.0,0));
    else CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon,rayon*2.0,8,16+17,17/1800.0,128.0/1024.0,128.0/1024.0,16));
    srand((time_t) rand());
}

bool CEnnemiFixSol::frameMove(float elapsedTime)
{
    if(pos.z<-10.0)return true;
    
    if(colid_flags==0)
    {
        boom();
        srand((time_t) rand());   
        return true;
    }
    
    float kLR,kUD;
    kLR=0.0;
    kUD=0.0;
    
    bool kSpace;
    //bool kLeft,kRight,kDown,kUp;
    //kLeft=kRight=kDown=kUp=
    kSpace=false;
    
    float flt;
    
    if(politique==P_APPROCHE || politique==P_ATTACK)
    {
        if(ciblePos)
        {
            flt=getImct();
            if(flt>0.0)
            {
                targ=*cibleVel;
                targ*=flt;
                targ+=*ciblePos;
            }
            else targ=*ciblePos;
                    
            /*
            Vecteur trg;
            //targ=*ciblePos;
            flt=getImct();
            if(flt>0.0)
            {
                trg=*cibleVel;
                trg*=flt;
                trg+=*ciblePos;
            }
            else trg=*ciblePos;
            
            float tmpz=trg.z;
            trg*=TARG_MOV_SPEED;
            targ*=(1.0f-TARG_MOV_SPEED);
            targ+=trg;
            targ.z=tmpz;
            */
            
            if(politique==P_APPROCHE){if(pos.z<3000.0)politique=P_ATTACK;}
            else{if(pos.z<50.0)politique=P_FUITE;}
        }
        else politique=P_FUITE;
    }
    else if(politique==P_FUITE)
    {
        //targ.z=-100;
    }
    
    Vecteur t,T;
    mod3.getAxeZ(t);
    
    T=targ;
    T.x-=pos.x;
    T.y-=mod3.getPosY()+rayon*0.5;
    T.z-=pos.z;
    T.normalize();
    
    flt=T*t;
    
    if(politique==P_ATTACK && flt>=0.99)kSpace=true;
    
    if(flt<(1.0-PRESSISION))
    {
        mod3.getAxeX(t);
        
        /*
        flt=T*t;
        if(flt<-PRESSISION)kRight=true;
        else if(flt>PRESSISION)kLeft=true;
        
        mod3.getAxeY(t);
        flt=T*t;
        if(flt<-PRESSISION)kUp=true;
        else if(flt>PRESSISION)kDown=true;
        */
        
        #define spdRtF 0.002
        #define spdLmnt 0.0004
        
        flt=T*t;
        if(flt<-PRESSISION)kLR=spdRtF*flt;
        else if(flt>PRESSISION)kLR=spdRtF*flt;
        
        if(kLR>spdLmnt)kLR=spdLmnt;
        else if(kLR<-spdLmnt)kLR=-spdLmnt;
        
        mod3.getAxeY(t);
        flt=T*t;
        if(flt<-PRESSISION)kUD=spdRtF*flt;
        else if(flt>PRESSISION)kUD=spdRtF*flt;
        
        if(kUD>spdLmnt)kUD=spdLmnt;
        else if(kUD<-spdLmnt)kUD=-spdLmnt;
    }
    
    forceFrotement(frotX,0.989,elapsedTime);
    forceFrotement(frotY,0.989,elapsedTime);
    
    /*
    if(kLeft)frotY+=0.00001*elapsedTime;
    if(kRight)frotY-=0.00001*elapsedTime;
    if(kDown)frotX+=0.0001*elapsedTime;
    if(kUp)frotX-=0.0001*elapsedTime;
    */
    
    frotY+=kLR*elapsedTime;
    frotX+=kUD*elapsedTime;
    
    rotX+=frotX*0.4*elapsedTime;
    rotY+=frotY*0.4*elapsedTime;
    
    if(rotX<minRX)rotX=minRX;
    else if(rotX>maxRX)rotX=maxRX;
    
    mod2.setRotation(0.0,rotY,0.0);
    mod3.setRotation(rotX,rotY,0.0);
    
    if(timeShot>0.0)timeShot-=elapsedTime;
    if(kSpace)
    {
        if(timeShot<=0.0)Shoot();
    }
    
    return false;
}

void CEnnemiFixSol::render()
{
    glPushMatrix();
    glTranslatef(pos.x,pos.y+h1,pos.z);
    mod1->draw();
    glPopMatrix();
    mod2.setPositionZ(pos.z);
    mod2.draw();
    mod3.setPositionZ(pos.z);
    mod3.draw();
    if(mod4)
    {
        glPushMatrix();
        mod3.applyMatrix();
        mod4->draw();
        glPopMatrix();
    }
}

#define CFLH 0.25

//calcul des vecteurs de tires
void CEnnemiFixSol::Shoot()
{
    Vecteur vl,t,f;
    //vl+vel;
    
    //if(bRL)t.x=(0.29/4.0)*scal;//0.521946;
    //else t.x=(-0.29/4.0)*scal;//0.521946;
    
    if(/*0<=bRL && */bRL<=2)
    {
        t.y=-CFLH;
        
        if(bRL==0)t.x=-CFLH;
        else if(bRL==2)t.x=CFLH;
        else t.x=0.0;
    }
    else if(6<=bRL && bRL<=8)
    {
        t.y=CFLH;
        
        if(bRL==6)t.x=-CFLH;
        else if(bRL==8)t.x=CFLH;
        else t.x=0.0;
    }
    else
    {
        t.y=0.0;
        if(bRL==3)t.x=-CFLH;
        else if(bRL==5)t.x=CFLH;
        else t.x=0;
    }
    
    t.x*=rayon;
    t.y*=rayon;
    t.y+=rayon*0.5;
    t.z=rayon+4.0;//0.521946;
    mod3.multVect(t,t);
    
    bRL=(bRL+1)%9;
    
    mod3.getAxeZ(vl);
    f=vl;
    
    vl*=0.1;
    
    mod3.addPos(t);
    
    projectilT(t,vl,f);
}

//gnration du projectil
void CEnnemiFixSol::projectilT(Vecteur &t,Vecteur &vl,Vecteur &f)
{
    timeShot=tmShot;
    CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.3);
    CApplication::selfPointer->mCld.addCollideSf(new CMissile(MISSILE1,3000.0,dmgS,t.x,t.y,t.z,f.x,f.y,f.z,vl.x,vl.y,vl.z,10.0,5.2,0.0,0.99));
}


CEnnemiFixSol::CEnnemiFixSol(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM1,unsigned char idM2,unsigned char idM3,unsigned char idM4,float minRX,float maxRX,float PRESSISION,float px,float py,float pz,float rayon,float coefElastic)
:CEnnemiFix(shield,dmgS,tmShot,px,py,pz,rayon,coefElastic)//,targ(px+0.0f,py+0.0f,pz+1.0f)
{
    this->minRX=minRX;
    this->maxRX=maxRX;
    
    rotX=0.0;
    rotY=PI;
    
    frotX=frotY=0.0;
    
    float h1;
    float h2;
    float h3;
    
    switch(idM1)
    {
        case LAUNCHER1_B:h1=-(190.0*125.0*SCL_LAUNCHER1)/120.0;h2=((100.0-120.0)*125.0*SCL_LAUNCHER1)/120.0;h3=((200.0-120.0)*125.0*SCL_LAUNCHER1)/120.0;break;
        case TURRET1_B:h1=-(63.0*90.0*SCL_TURRET1)/99.0;h2=(47.4*90.0*SCL_TURRET1)/99.0;h3=(54.6*90.0*SCL_TURRET1)/99.0;break;
        default:h1=-230.0/120.0;h2=(100.0-120.0)/120.0;h3=(200.0-120.0)/120.0;//break;
    }
    
    /*
    h1*=rayon;
    h2*=rayon;
    h3*=rayon;
    */
    
    this->h1=h1;
    
    mod1=CApplication::selfPointer->protoBob.getPrototype(idM1);
    mod2.loadObj(CApplication::selfPointer->protoBob.getPrototype(idM2));
    mod2.setPosition(px,py+h2,pz);
    mod3.loadObj(CApplication::selfPointer->protoBob.getPrototype(idM3));
    mod3.setPosition(px,py+h3,pz);
    mod4=CApplication::selfPointer->protoBob.getPrototype(idM4);
    
    bRL=false;
    timeShot=0.0;

    this->PRESSISION=PRESSISION;

    politique=P_APPROCHE;
    this->idMProj=idMProj;
    
    dmg=1;
}

CEnnemiFixSol::~CEnnemiFixSol()
{
}
//----------------------------------------------------------------------------------------









//====================================== CEnnemiFixSol2 =======================================
//Explosion de l'unit au sol
void CEnnemiFixSol2::boom()
{
    CApplication::selfPointer->o_son.playSound(EXPLOENM+rand()%NBEXPLO,pos.z,0.5);
    if(rand()%2)CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon,rayon*2.5,8,16,17/1800.0,128.0/1024.0,128.0/1024.0,0));
    else CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.18,1800.0,rayon,rayon*2.5,8,16+17,17/1800.0,128.0/1024.0,128.0/1024.0,16));
    srand((time_t) rand());
}

//On redfinit l'appel du calcul d'impact pour indiquer que c'est la vitesse des lasers
float CEnnemiFixSol2::getImct()
{
    return calculCibleImpact(1.3,(rayon+1.5),mod3.getPosY()+rayon*0.15);//vel.length()
}

void CEnnemiFixSol2::Shoot()
{
    Vecteur vl,t,f;
    //vl+vel;
    
    //if(bRL)t.x=(0.29/4.0)*scal;//0.521946;
    //else t.x=(-0.29/4.0)*scal;//0.521946;
    
    //t.x*=rayon;
    //t.y*=rayon;
    t.x=rayon*(bRL?-0.35:0.35);
    t.y+=rayon*0.15;
    t.z=rayon+1.5;//0.521946;
    mod3.multVect(t,t);
    
    if(bRL)bRL=false;else bRL=true;
    
    mod3.getAxeZ(vl);
    
    vl*=1.3;
    
    f.x=f.y=f.z=0.0;
    
    mod3.addPos(t);
    
    projectilT(t,vl,f);
}

void CEnnemiFixSol2::projectilT(Vecteur &t,Vecteur &vl,Vecteur &f)
{
    timeShot=tmShot;
    CApplication::selfPointer->o_son.playSound(TURRETSHOT,pos.z,0.45);
    CApplication::selfPointer->mCld.addLaser(new CProjectil(idMProj,2000.0,dmgS,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,1.5,3.0,0.0,1.0));
}

CEnnemiFixSol2::CEnnemiFixSol2(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM1,unsigned char idM2,unsigned char idM3,unsigned char idM4,float minRX,float maxRX,float PRESSISION,float px,float py,float pz,float rayon,float coefElastic)
:CEnnemiFixSol(shield,idMProj,dmgS,tmShot,idM1,idM2,idM3,idM4,minRX,maxRX,PRESSISION,px,py,pz,rayon,coefElastic)
{
}

CEnnemiFixSol2::~CEnnemiFixSol2()
{
}
//----------------------------------------------------------------------------------------
